/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items.crafting;

import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperRecipe;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.items.crafting.NpcShapelessRecipes;
import noppes.npcs.reflection.item.crafting.IngredientReflection;
import noppes.npcs.reflection.item.crafting.ShapedRecipesReflection;
import noppes.npcs.util.Util;

public class NpcShapedRecipes
extends ShapedRecipes
implements INpcRecipe,
IRecipe {
    public int field_77576_b;
    public int field_77577_c;
    public NonNullList<Ingredient> field_77574_d;
    private ItemStack recipeOutput;
    public Availability availability;
    private boolean global;
    public int id;
    public boolean ignoreDamage;
    public boolean ignoreNBT;
    public boolean known;
    public boolean main = false;
    public String name;
    public boolean savesRecipe;
    private final WrapperRecipe wrapper = new WrapperRecipe();

    public static INpcRecipe createRecipe(String group, String name, boolean global, ItemStack stack, Object ... map) {
        StringBuilder allRows = new StringBuilder();
        int objPos = 0;
        int width = 0;
        int height = 0;
        if (map[objPos] instanceof String[]) {
            String[] var8;
            String[] var7 = var8 = (String[])map[objPos++];
            int var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String row = var8[var10];
                ++height;
                width = row.length();
                allRows.append(row);
            }
        } else {
            while (map[objPos] instanceof String) {
                String row = (String)map[objPos++];
                ++height;
                width = row.length();
                allRows.append(row);
            }
        }
        HashMap<Character, ItemStack> mapIngredients = new HashMap<Character, ItemStack>();
        while (objPos < map.length) {
            Character c = (Character)map[objPos];
            ItemStack st = ItemStack.field_190927_a;
            if (map[objPos + 1] instanceof Item) {
                st = new ItemStack((Item)map[objPos + 1]);
            } else if (map[objPos + 1] instanceof Block) {
                st = new ItemStack((Block)map[objPos + 1], 1, -1);
            } else if (map[objPos + 1] instanceof ItemStack) {
                st = (ItemStack)map[objPos + 1];
            }
            mapIngredients.put(c, st);
            objPos += 2;
        }
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int slot = 0; slot < width * height; ++slot) {
            char c = allRows.charAt(slot);
            if (mapIngredients.containsKey(Character.valueOf(c))) {
                ingredients.add(slot, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)mapIngredients.get(Character.valueOf(c))).func_77946_l()}));
                continue;
            }
            ingredients.add(slot, (Object)Ingredient.field_193370_a);
        }
        return new NpcShapedRecipes(group, name, global, (NonNullList<Ingredient>)ingredients, stack);
    }

    public static NpcShapedRecipes read(NBTTagCompound compound) {
        NpcShapedRecipes recipe = new NpcShapedRecipes(Util.instance.getResourceName(compound.func_74779_i("Group")), Util.instance.getResourceName(compound.func_74779_i("Name")), compound.func_74767_n("Global"), NBTTags.getIngredientList(compound.func_150295_c("Materials", 10)), new ItemStack(compound.func_74775_l("Item")));
        recipe.field_77576_b = compound.func_74762_e("Width");
        recipe.field_77577_c = compound.func_74762_e("Height");
        recipe.id = compound.func_74762_e("ID");
        recipe.availability.load(compound.func_74775_l("Availability"));
        recipe.ignoreDamage = compound.func_74767_n("IgnoreDamage");
        recipe.ignoreNBT = compound.func_74767_n("IgnoreNBT");
        recipe.known = compound.func_74767_n("IsKnown");
        recipe.main = compound.func_74767_n("IsMain");
        return recipe;
    }

    public Object[] getGrid() {
        int startW = -1;
        int startH = -1;
        int maxW = 0;
        int maxH = 0;
        TreeMap<Integer, Ingredient> map = new TreeMap<Integer, Ingredient>();
        for (int i = 0; i < this.field_77574_d.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.field_77574_d.get(i);
            if (ingredient.func_193365_a().length <= 0) continue;
            boolean hasStack = false;
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (NoppesUtilServer.IsItemStackNull(stack)) continue;
                hasStack = true;
                break;
            }
            if (!hasStack) continue;
            int iW = i % this.field_77576_b;
            int iH = i / this.field_77577_c;
            if (startW == -1) {
                startW = iW;
                startH = iH;
            }
            map.put(i, ingredient);
            if (maxW < iW - startW + 1) {
                maxW = iW - startW + 1;
            }
            if (maxH >= iH - startH + 1) continue;
            maxH = iH - startH + 1;
        }
        NonNullList newIngredient = this.field_77574_d;
        if (startW != -1 && maxW != 0 && maxH != 0 && (this.field_77576_b != maxW || this.field_77577_c != maxH)) {
            newIngredient = NonNullList.func_191196_a();
            for (int y = 0; y < maxH; ++y) {
                for (int x = 0; x < maxW; ++x) {
                    int slotIndex = (y + startH) * this.field_77576_b + (x + startW);
                    newIngredient.add((Object)map.getOrDefault(slotIndex, Ingredient.field_193370_a));
                }
            }
        } else {
            maxW = this.field_77576_b;
            maxH = this.field_77577_c;
        }
        return new Object[]{maxW, maxH, newIngredient};
    }

    public NpcShapedRecipes(String group, String name, boolean isGlobal, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(Util.instance.getResourceName(group), isGlobal ? 3 : 4, isGlobal ? 3 : 4, ingredients, result);
        this.field_77576_b = isGlobal ? 3 : 4;
        int n = this.field_77577_c = isGlobal ? 3 : 4;
        if (ingredients.isEmpty()) {
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150347_e)}));
        }
        this.field_77574_d = ingredients;
        if (result.func_190926_b()) {
            result = new ItemStack(Blocks.field_150347_e);
        }
        this.recipeOutput = result;
        this.id = -1;
        this.name = Util.instance.getResourceName(name);
        this.availability = new Availability();
        this.global = isGlobal;
        this.ignoreDamage = false;
        this.ignoreNBT = false;
        this.savesRecipe = true;
        this.known = true;
        if (this.getRegistryName() == null) {
            this.setRegistryName(new ResourceLocation("customnpcs", this.func_193358_e() + "_" + this.name));
        }
    }

    public boolean apply(@Nullable Ingredient ingredient, @Nullable ItemStack stack) {
        if (stack == null || ingredient == null) {
            return false;
        }
        ItemStack[] stacks = ingredient.func_193365_a();
        if (stacks.length == 0 && stack.func_190926_b()) {
            return true;
        }
        for (ItemStack ingStack : stacks) {
            if (ingStack.func_77973_b() != stack.func_77973_b() || ingStack.func_190926_b() || stack.func_190926_b() || !NoppesUtilPlayer.compareItems(stack, ingStack, this.ignoreDamage, this.ignoreNBT) || ingStack.func_190916_E() > stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public boolean func_194133_a(int width, int height) {
        if (!(this.global || width == 4 && height == 4)) {
            return false;
        }
        Object[] objs = this.getGrid();
        int recipeW = (Integer)objs[0];
        int recipeH = (Integer)objs[1];
        return width >= recipeW && height >= recipeH;
    }

    @Override
    public void copy(INpcRecipe recipe) {
        int w;
        NonNullList<Ingredient> ingredients;
        if (recipe == null || this == recipe) {
            return;
        }
        this.id = recipe.getId();
        this.name = recipe.getName();
        this.availability = (Availability)recipe.getAvailability();
        this.global = recipe.isGlobal();
        this.ignoreDamage = recipe.getIgnoreDamage();
        this.ignoreNBT = recipe.getIgnoreNBT();
        this.recipeOutput = recipe.getProduct().getMCItemStack();
        NonNullList<Ingredient> nonNullList = ingredients = recipe instanceof NpcShapelessRecipes ? ((NpcShapelessRecipes)recipe).field_77579_b : ((NpcShapedRecipes)recipe).field_77574_d;
        if (this.field_77574_d != ingredients) {
            this.field_77574_d.clear();
            for (Ingredient ing : ingredients) {
                if (ing.func_193365_a().length == 0) {
                    this.field_77574_d.add((Object)Ingredient.field_193370_a);
                    continue;
                }
                this.field_77574_d.add((Object)Ingredient.func_193369_a((ItemStack[])ing.func_193365_a()));
            }
        }
        ShapedRecipesReflection.setGroup(this, recipe.getNpcGroup());
        this.known = recipe.isKnown();
        this.field_77576_b = recipe.getWidthRecipe();
        this.field_77577_c = recipe.getHeightRecipe();
        int n = w = this.global ? 3 : 4;
        if (this.field_77576_b > w) {
            this.field_77576_b = w;
        }
        if (this.field_77577_c > w) {
            this.field_77577_c = w;
        }
        if (this.getRegistryName() == null) {
            this.setRegistryName(new ResourceLocation("customnpcs", this.func_193358_e() + "_" + this.name));
        }
        this.savesRecipe = true;
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean equal(INpcRecipe recipe) {
        return recipe.getClass() == NpcShapedRecipes.class && recipe.getNpcGroup().equals(this.func_193358_e()) && recipe.getName().equals(this.name) && ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)recipe.getProduct().getMCItemStack(), (ItemStack)this.recipeOutput);
    }

    public boolean equals(INpcRecipe recipe) {
        return recipe.isShaped() && this.id == recipe.getId() && recipe.isGlobal() == this.global && recipe.getName().equals(this.name) && recipe.getNpcGroup().equals(this.func_193358_e());
    }

    @Override
    public IAvailability getAvailability() {
        return this.availability;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        if (this.recipeOutput.func_190926_b()) {
            System.out.println("[DEBUG] Recipe output is empty for recipe: " + this.getRegistryName());
            return ItemStack.field_190927_a;
        }
        return this.recipeOutput.func_77946_l();
    }

    @Override
    public int getHeightRecipe() {
        return this.field_77577_c;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean getIgnoreDamage() {
        return this.ignoreDamage;
    }

    @Override
    public boolean getIgnoreNBT() {
        return this.ignoreNBT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INbt getNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("Width", this.field_77576_b);
        compound.func_74768_a("Height", this.field_77577_c);
        if (this.recipeOutput != null) {
            compound.func_74782_a("Item", (NBTBase)this.recipeOutput.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Materials", (NBTBase)NBTTags.nbtIngredientList(this.field_77574_d));
        compound.func_74782_a("Availability", (NBTBase)this.availability.save(new NBTTagCompound()));
        compound.func_74778_a("Name", this.name);
        compound.func_74757_a("Global", this.global);
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        compound.func_74778_a("Group", this.func_193358_e());
        compound.func_74757_a("IsKnown", this.known);
        compound.func_74757_a("IsShaped", true);
        compound.func_74757_a("IsMain", this.main);
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(compound);
    }

    @Override
    public String getNpcGroup() {
        return this.func_193358_e();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Override
    public IItemStack getProduct() {
        return (IItemStack)this.func_77571_b().getCapability(ItemStackWrapper.ITEM_SCRIPTED_DATA_CAPABILITY, null);
    }

    @Override
    public IItemStack[][] getRecipe() {
        IItemStack[][] allStacks = new IItemStack[this.field_77574_d.size()][];
        for (int i = 0; i < this.field_77574_d.size(); ++i) {
            ItemStack[] arr = ((Ingredient)this.field_77574_d.get(i)).func_193365_a();
            allStacks[i] = new IItemStack[arr.length];
            for (int j = 0; j < arr.length; ++j) {
                allStacks[i][j] = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(arr[j]);
            }
        }
        return allStacks;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inventoryCrafting) {
        NonNullList list = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            list.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return list;
    }

    @Override
    public int getWidthRecipe() {
        return this.field_77576_b;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public boolean isKnown() {
        return this.known;
    }

    @Override
    public boolean isShaped() {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.getRegistryName() == null) {
            this.setRegistryName(new ResourceLocation("customnpcs", this.func_193358_e() + "_" + this.name));
        }
        if (this.func_193358_e().isEmpty()) {
            return false;
        }
        if (this.name == null || this.name.isEmpty()) {
            return false;
        }
        if (this.field_77574_d.isEmpty() || this.recipeOutput.func_190926_b()) {
            return false;
        }
        for (Ingredient ing : this.field_77574_d) {
            if (ing.func_193365_a().length == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRecipeItemsEmpty() {
        for (Ingredient ingredient : this.field_77574_d) {
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (stack == null || stack.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public WrapperRecipe getWrapperRecipe() {
        this.wrapper.parent = this;
        this.wrapper.isShaped = true;
        this.wrapper.global = this.global;
        this.wrapper.known = this.known;
        this.wrapper.ignoreDamage = this.ignoreDamage;
        this.wrapper.ignoreNBT = this.ignoreNBT;
        this.wrapper.id = this.id;
        this.wrapper.width = this.field_77576_b;
        this.wrapper.height = this.field_77577_c;
        this.wrapper.group = this.func_193358_e();
        this.wrapper.domen = "customnpcs";
        this.wrapper.name = (this.main ? "\u00a7b" : "") + this.name;
        this.wrapper.product = this.recipeOutput.func_77946_l();
        this.wrapper.availability.load(this.availability.save(new NBTTagCompound()));
        this.wrapper.main = this.main;
        this.wrapper.recipeItems.clear();
        int pos = 0;
        for (Ingredient ingr : this.field_77574_d) {
            ItemStack[] rawMatchingStacks = IngredientReflection.getRawMatchingStacks(ingr);
            ItemStack[] array = new ItemStack[rawMatchingStacks.length];
            for (int j = 0; j < rawMatchingStacks.length; ++j) {
                array[j] = rawMatchingStacks[j].func_77946_l();
            }
            this.wrapper.recipeItems.put(pos, array);
            ++pos;
        }
        return this.wrapper;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public boolean isChanged() {
        return this.savesRecipe;
    }

    @Override
    public void setRecipeOutput(ItemStack cms) {
        if (cms == null || cms.func_190926_b()) {
            return;
        }
        this.recipeOutput = cms.func_77946_l();
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nullable World world) {
        if (this.field_77574_d.isEmpty()) {
            return false;
        }
        Object[] grid = this.getGrid();
        int recipeW = (Integer)grid[0];
        int recipeH = (Integer)grid[1];
        NonNullList ingredients = (NonNullList)grid[2];
        for (int offsetY = 0; offsetY <= inv.func_174923_h() - recipeH; ++offsetY) {
            for (int offsetX = 0; offsetX <= inv.func_174922_i() - recipeW; ++offsetX) {
                boolean match = true;
                for (int y = 0; y < recipeH && match; ++y) {
                    for (int x = 0; x < recipeW && match; ++x) {
                        ItemStack slotStack;
                        int gridIndex = x + y * recipeW;
                        Ingredient ingredient = (Ingredient)ingredients.get(gridIndex);
                        if (!ingredient.apply(slotStack = inv.func_70463_b(x + offsetX, y + offsetY))) {
                            match = false;
                            continue;
                        }
                        if (slotStack.func_190926_b()) continue;
                        boolean foundMatch = false;
                        for (ItemStack ingStack : ingredient.func_193365_a()) {
                            if (ingStack.func_190926_b() || !NoppesUtilPlayer.compareItems(slotStack, ingStack, this.ignoreDamage, this.ignoreNBT)) continue;
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setIgnoreDamage(boolean bo) {
        this.ignoreDamage = bo;
        this.savesRecipe = true;
    }

    @Override
    public void setIgnoreNBT(boolean bo) {
        this.ignoreNBT = bo;
        this.savesRecipe = true;
    }

    @Override
    public void setKnown(boolean bo) {
        this.known = bo;
        this.savesRecipe = true;
    }

    @Override
    public void setNbt(INbt nbt) {
        this.copy(NpcShapedRecipes.read(nbt.getMCNBT()));
    }
}

